/************************************************************************
* COPYRIGHT:   Copyright  2001 Symbol Technologies, Inc.
*
* FILE:        S24APIStruct.h
*
*************************************************************************/
#pragma once

#include "S24Defines.h"

// These prefs can be get/set using netIFSettingS24Preferences
// They are also changeable in the S24 Preferences Panel
typedef struct
{
    Char        szESSID[S24_ESS_ID_LENGTH + 1];     // ESS ID to use when associating 
    Boolean     bShowESSID;                         // Show ESS ID string on association screen?
    Boolean     bUseDHCP;                           // Shall we use DHCP?
    Boolean     bEnableDNS;                         // Enable DNS?
    NetIPAddr   addrStaticIP;                       // Static IP of the S24 device
    NetIPAddr   addrSubnetMask;                     // Subnet mask for the S24 device
    NetIPAddr   addrGateway;                        // Gateway used by the S24 device
    NetIPAddr   addrPrimaryDNS;                     // Primary DNS used by the S24 device
    NetIPAddr   addrSecondaryDNS;                   // Secondary DNS used by the S24 device
    Char        szHostName[S24_HOST_NAME_LEN];      // Host name of the S24 device
    Char        szDomainName[S24_DOMAIN_NAME_LEN];  // Domain name of the S24 device
} S24UserNetworkPrefs;

// Callsign data structure
typedef struct
{
    Boolean valid;                                  // Is it valid?
    UInt8   callsign[S24_MKK_CALLSIGN_LEN];         // Callsign data
} S24MKKCallsign;

// I/F setting structure, used to pass complex data structures to NetLibIFSettingGet/Set
typedef struct
{
    UInt16  option;                                 // I/F setting option, ie: S24 preference number
    MemPtr  buffer;                                 // Buffer to store retrieved setting
} S24IFSetting;
